/*-------------------------------------------------------*
*  Name:      RAWTexture.zmt for ZModeler version 1.05   *
*  Purpose:   Demonstration only                         *
*  Authors:                                              *
*                                                        *
*  History:                                              *
*                                                        *
*-------------------------------------------------------*/
#include "Struct.h"
#include "3DEngine.h"

DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}


DWORD CALLBACK Supports(long)
{
  return Z3D_PLUGSUPPORTS_TEXTURELOADING;
}

DWORD CALLBACK DynamicLoading(long)
{
  return 1;
}

char* CALLBACK GetTextureExtensions(DWORD)
{
  return "raw\r\n";
}


DWORD CALLBACK LoadTexture(char* pName)
{
  CFile RAW;
  if (!RAW.Open(pName, CFile::modeRead))
    return NULL;

  short  LinearSize = 2;
  long  DataSize = RAW.GetLength();

  while (DataSize > LinearSize*LinearSize*3)
    LinearSize*=2;
  if (DataSize != LinearSize*LinearSize*3)
    return NULL;//size was not guessed.

  sTextureDescriptor* pDesc = new sTextureDescriptor;
  if (NULL == strrchr( pName, '\\'))
    pDesc->pName =  pName;
  else
    pDesc->pName = (strrchr( pName, '\\') + 1);

  pDesc->pRGBAData = new DWORD[LinearSize*LinearSize];
  pDesc->dwWidth = LinearSize;
  pDesc->dwHeight= LinearSize;
  pDesc->dwBPP   = 32;

  BYTE* pBuffer = new BYTE[DataSize];
  RAW.ReadHuge(pBuffer, DataSize);
  BYTE* pDestination = (BYTE*)pDesc->pRGBAData;

  long pixel = 0;
  while (pixel < DataSize/3)
  {
    pDestination[pixel*4]  = 0xFF;          //a
    pDestination[pixel*4+1]  = pBuffer[pixel*3+2];  //b
    pDestination[pixel*4+2]  = pBuffer[pixel*3+1];  //g
    pDestination[pixel*4+3]  = pBuffer[pixel*3];    //r
    pixel++;
  }
  delete[] pBuffer;
  RAW.Close();

    return (DWORD)pDesc;
}
